﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Xml;

public partial class Admin_NeiRong_YinYue_XiuGai : System.Web.UI.Page
{
    private 访问 访问;
    private new int ID;
    protected String 分类代码;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改音乐", "网站后台", "修改音乐", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        ID = Convert.ToInt32(Request.QueryString["ID"]);
        if (this.IsPostBack)
            保存();
        else
            初始化();
    }

    private void 初始化()
    {
        NeiRongMoBan.Items.Add(new ListItem("默认模板", "0"));
        NeiRongMoBan_3G.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan_3G.Items.Add(new ListItem("默认模板", "0"));

        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 程序.设置["默认模板"] + "/Content/")).GetFiles();

        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            String _内容类型 = "";
            bool 是否WAP = true;

            XmlReader 读取 = XmlReader.Create(FIS[i].OpenRead());
            while (读取.Read())
                if (读取.NodeType == XmlNodeType.Element)
                    if (读取.Name == "set")
                        if (读取.GetAttribute("name") == "ID")
                            ID = Convert.ToInt32(读取.GetAttribute("value"));
                        else if (读取.GetAttribute("name") == "模板名称")
                            模板名称 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "模板类型")
                            模板类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "内容类型")
                            _内容类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "是否WAP")
                            是否WAP = Convert.ToBoolean(读取.GetAttribute("value"));
            读取.Close();

            if (_内容类型 == "文章")
                switch (模板类型)
                {
                    case "查看内容":
                        if (是否WAP)
                            NeiRongMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            NeiRongMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                    case "评论列表":
                        if (是否WAP)
                            PingLunMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            PingLunMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                }
        }

        Hashtable 音乐 = 常用.SQL_获取(new SqlCommand("SELECT * FROM [" + 程序.数据表前缀 + "内容_音乐_音乐] WHERE [ID]=" + this.ID, 访问.连接));

        if (音乐 == null)
            throw new Exception("音乐不存在");

        SqlCommand 语句 = new SqlCommand("SELECT [栏目名称] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [ID]=" + Convert.ToInt32(音乐["所属栏目"]), 访问.连接);
        SqlDataReader _读取 = 语句.ExecuteReader();
        if (_读取.Read())
            分类代码 = "<a href=\"" + Server.HtmlEncode(Request.QueryString["rurl"]) + "\">" + Convert.ToString(_读取["栏目名称"]) + "</a> &gt;";
        else
        {
            _读取.Close();
            throw new Exception("内容栏目不存在");
        }
        _读取.Close();

        BiaoTi.Text = 音乐["标题"].ToString();
        BiaoTiYangShi_YanSe.Text = 音乐["标题样式_颜色"].ToString();
        BiaoTiYangShi_ChuTi.Checked = Convert.ToBoolean(音乐["标题样式_粗体"]);
        BiaoTiYangShi_XieTi.Checked = Convert.ToBoolean(音乐["标题样式_斜体"]);
        BiaoTiYangShi_ShanChuXian.Checked = Convert.ToBoolean(音乐["标题样式_删除线"]);
        WaiBuLianJie.Text = Convert.ToString(音乐["外部链接"]);
        FaBuShiJian.Text = Convert.ToString(音乐["发布时间"]);
        ShiFouTuiJian.Checked = Convert.ToBoolean(音乐["是否推荐"]);
        GeShou.Text = Convert.ToString(音乐["歌手名称"]);
        ZhuanJi.Text = Convert.ToString(音乐["所属专辑"]);
        ShiFouGuanBiPingLun.Checked = Convert.ToBoolean(音乐["是否关闭评论"]);
        NeiRongMoBan.SelectedValue = Convert.ToString(音乐["内容模板"]);
        NeiRongMoBan_3G.SelectedValue = Convert.ToString(音乐["3G内容模板"]);
        PingLunMoBan.SelectedValue = Convert.ToString(音乐["评论模板"]);
        PingLunMoBan_3G.SelectedValue = Convert.ToString(音乐["3G评论模板"]);
        QuanXian_JinXiaoHuiYuan.Checked = Convert.ToBoolean(音乐["权限_仅限会员"]);
        QuanXian_XuYaoDenJi.Text = Convert.ToString(音乐["权限_需要等级"]);
        QuanXian_KouChuJiFen.Text = Convert.ToString(音乐["权限_扣除积分"]);
        String[] 地址数组 = Convert.ToString(音乐["文件资源"]).Split(new Char[]{','}, StringSplitOptions.RemoveEmptyEntries);

        String 文件代码 = "";
        for (int i = 0; i < 地址数组.Length; i++)
        {
            文件代码 += 地址数组[i] + "<br/>";
        }
        YinYueWenJian.Text = 文件代码;
    }

    private void 保存()
    {
        访问.验证权限("19");
        String 标题 = BiaoTi.Text;
        bool 标题样式_粗体 = BiaoTiYangShi_ChuTi.Checked;
        bool 标题样式_斜体 = BiaoTiYangShi_XieTi.Checked;
        bool 标题样式_删除线 = BiaoTiYangShi_ShanChuXian.Checked;
        String 标题样式_颜色 = BiaoTiYangShi_YanSe.Text;
        bool 是否推荐 = ShiFouTuiJian.Checked;
        String 外部链接 = WaiBuLianJie.Text;
        DateTime 发布时间 = Convert.ToDateTime(FaBuShiJian.Text);
        String 歌手名称 = GeShou.Text;
        String 所属专辑 = ZhuanJi.Text;
        bool 是否关闭评论 = ShiFouGuanBiPingLun.Checked;
        int 内容模板 = Convert.ToInt32(NeiRongMoBan.SelectedValue);
        int 内容模板_3G = Convert.ToInt32(NeiRongMoBan_3G.SelectedValue);
        int 评论模板 = Convert.ToInt32(PingLunMoBan.SelectedValue);
        int 评论模板_3G = Convert.ToInt32(PingLunMoBan_3G.SelectedValue);
        bool 权限_仅限会员 = QuanXian_JinXiaoHuiYuan.Checked;
        int 权限_需要等级 = Convert.ToInt32(QuanXian_XuYaoDenJi.Text);
        int 权限_扣除积分 = Convert.ToInt32(QuanXian_KouChuJiFen.Text);

        if (标题 == "")
            throw new Exception("标题不能为空");

        SqlCommand 语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_音乐_音乐] SET " +
            "[标题]=@标题," +
            "[标题样式_粗体]=@标题样式_粗体," +
            "[标题样式_斜体]=@标题样式_斜体," +
            "[标题样式_删除线]=@标题样式_删除线," +
            "[标题样式_颜色]=@标题样式_颜色," +
            "[是否推荐]=@是否推荐," +
            "[外部链接]=@外部链接," +
            "[发布时间]=@发布时间," +
            "[歌手名称]=@歌手名称," +
            "[所属专辑]=@所属专辑," +
            "[是否关闭评论]=@是否关闭评论," +
            "[内容模板]=@内容模板," +
            "[3G内容模板]=@3G内容模板,"+
            "[评论模板]=@评论模板," +
            "[3G评论模板]=@3G评论模板," +
            "[权限_仅限会员]=@权限_仅限会员," +
            "[权限_需要等级]=@权限_需要等级," +
            "[权限_扣除积分]=@权限_扣除积分 WHERE [ID]=" + ID, 访问.连接);
        语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 标题;
        语句.Parameters.Add("@标题样式_粗体", SqlDbType.Bit).Value = 标题样式_粗体;
        语句.Parameters.Add("@标题样式_斜体", SqlDbType.Bit).Value = 标题样式_斜体;
        语句.Parameters.Add("@标题样式_删除线", SqlDbType.Bit).Value = 标题样式_删除线;
        语句.Parameters.Add("@标题样式_颜色", SqlDbType.NVarChar).Value = 标题样式_颜色;
        语句.Parameters.Add("@是否推荐", SqlDbType.Bit).Value = 是否推荐;
        语句.Parameters.Add("@外部链接", SqlDbType.NVarChar).Value = 外部链接;
        语句.Parameters.Add("@发布时间", SqlDbType.DateTime).Value = 发布时间;
        语句.Parameters.Add("@歌手名称", SqlDbType.NVarChar).Value = 歌手名称;
        语句.Parameters.Add("@所属专辑", SqlDbType.NVarChar).Value = 所属专辑;
        语句.Parameters.Add("@是否关闭评论", SqlDbType.Bit).Value = 是否关闭评论;
        语句.Parameters.Add("@内容模板", SqlDbType.Int).Value = 内容模板;
        语句.Parameters.Add("@3G内容模板", SqlDbType.Int).Value = 内容模板_3G;
        语句.Parameters.Add("@评论模板", SqlDbType.Int).Value = 评论模板;
        语句.Parameters.Add("@3G评论模板", SqlDbType.Int).Value = 评论模板_3G;
        语句.Parameters.Add("@权限_仅限会员", SqlDbType.Bit).Value = 权限_仅限会员;
        语句.Parameters.Add("@权限_需要等级", SqlDbType.Int).Value = 权限_需要等级;
        语句.Parameters.Add("@权限_扣除积分", SqlDbType.Int).Value = 权限_扣除积分;
        语句.ExecuteNonQuery();
        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("修改音乐[" + 标题 + "]", 访问.用户["昵称"].ToString());

        Response.Redirect(Request.QueryString["rurl"]);
    }
}
